function svd_scatterplots(D,V,nmode)

% Pairwise SVD projection scatter plots

% The codebook matrix D can be represented by the chosen eigenneurons V(:,1:nmode) in the subspaces obtained by SVD. 
% Projection of prototype vectors into SVD subspaces and visualization with pair-wise scatter plots display the property, 
% that is, the father a prototype vector lies away from the origin, the stronger the contribution of that prototype vector 
% is to the variance accounted for by the subspace. In other words, the scatter of the noise tends to randomly distribute 
% around the origin. 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Both row-wise and column-wise permutation of D to generate permutated Drc
[m,n]=size(D);
%% First,generate row-wise permutated Dr
for i=1:m
    tmp=randperm(n);
    Dr(i,1:n)=D(i,tmp);
end
%% Second, perform column-wise permutation of Dr to finally generate Drc
for j=1:n
    tmp=randperm(m);
    Drc(1:m,j)=Dr(tmp,j);
end

% Projection of D into V to get Dv
Dv=D*V;
% Projection of Drc into V to get Dv
DrcV=Drc*V;


maxlim=max(max(Dv));% the initial maximum axis limits  
minlim=min(min(Dv));% the initial minimum axis limits
% adjust the axis limits to make sure that both are symmetric and span the each subpace
if maxlim>=abs(minlim)
    maxlim=ceil(maxlim);
    minlim=-ceil(maxlim);
else
    minlim=floor(minlim);
    maxlim=-floor(minlim);
end

lp=nmode;% the number of subspaces identifed by SVD
% Pairwise SVD projection scatter plots
scrsz = get(0,'ScreenSize');
figure('Position',[scrsz(4)*1/10 scrsz(4)*1/10 scrsz(4)*9.2/10 scrsz(4)*8/10])
set(gcf,'color','w');
for i=1:lp
    for j=1:lp
        %% below the diagonal for pairwise Dv (and DrcV) scatter plots
        %% on the diagonal for self Dv (and DrcV) scatter plots
        if i<=j
            subplot(lp,lp,i+lp*(j-1))
            plot(Dv(:,i),Dv(:,j),'.','color',[1 0 0],'markersize',4) % for Dv marked with red points
            hold on
            plot(DrcV(:,i),DrcV(:,j),'.','color',[0 0 1],'markersize',4) % for Drc marked with blue points
            grid on;
            set(gca,'fontsize',8,'xlim',[minlim maxlim],'xtick',[],'ylim',[minlim maxlim],'ytick',[])
            if j==lp & i==lp
                set(gca,'yaxislocation','right')
            end
            if i==1 & j==1
                set(gca,'xaxislocation','top')
            end
            if j==lp
                xlabel(['Proj. # ',num2str(i)]);set(gca,'xlim',[minlim maxlim],'xtick',[minlim 0 maxlim]);
            end
            if i==1
                ylabel(['Proj. # ',num2str(j)]);set(gca,'ylim',[minlim maxlim],'ytick',[minlim 0 maxlim]);
            end
            if j==1
                xlabel(['Proj. # ',num2str(i)]);set(gca,'xlim',[minlim maxlim],'xtick',[minlim 0 maxlim]);
            end
            if i==lp
                ylabel(['Proj. # ',num2str(j)]);set(gca,'ylim',[minlim maxlim],'ytick',[minlim 0 maxlim]);   
            end
        end
        %% above the diagonal for self Dv (both horizonal and vertical) scatter plots
        if i>j
            subplot(lp,lp,i+lp*(j-1))
            plot(Dv(:,i),Dv(:,i),'o','color',[0 1 0],'markersize',6) % for vertically self scallte plot of Dv marked with black circles
            hold on
            plot(Dv(:,j),Dv(:,j),'*','color',[0 0 0],'markersize',3) % for horizonally self scallte plot of Dv marked with black stars
            grid on;
            set(gca,'fontsize',8,'xlim',[minlim maxlim],'xtick',[],'ylim',[minlim maxlim],'ytick',[])
            set(gca,'xaxislocation','top','yaxislocation','right')
            if j==lp
                xlabel(['Proj. # ',num2str(i)]);set(gca,'xlim',[minlim maxlim],'xtick',[minlim 0 maxlim]);
            end
            if i==1
                ylabel(['Proj. # ',num2str(j)]);set(gca,'ylim',[minlim maxlim],'ytick',[minlim 0 maxlim]);
            end
            if j==1
                xlabel(['Proj. # ',num2str(i)]);set(gca,'xlim',[minlim maxlim],'xtick',[minlim 0 maxlim]);
            end
            if i==lp
                ylabel(['Proj. # ',num2str(j)]);set(gca,'ylim',[minlim maxlim],'ytick',[minlim 0 maxlim]);   
            end
        end
    end
end

return
